<?php
$query_array=array("headline"=>__("List all mapped drives with hosts"),
                   "sql" => "SELECT system.system_uuid, system.system_name, mapped.mapped_device_id, mapped.mapped_username, mapped.mapped_provider_name, mapped.mapped_connect_as 
                             FROM system AS system, mapped AS mapped 
                             WHERE system.system_uuid = mapped.mapped_uuid AND mapped.mapped_timestamp = system.system_timestamp ",
                   "sort"=>"system_name, mapped_username",
                   "dir"=>"ASC",
                   "get"=>array("file"=>"system.php",
                                "title"=>__("Go to System"),
                                "var"=>array("pc"=>"%system_uuid",
                                             "view"=>"summary",
                                            ),
                               ),
                   "fields"=>array("10"=>array("name"=>"system_uuid",
                                               "head"=>__("UUID"),
                                               "show"=>"n",
                                              ),
                                   "20"=>array("name"=>"system_name",
                                               "head"=>__("Hostname"),
                                               "show"=>"y",
                                               "link"=>"y",
                                               "get"=>array("file"=>"system.php",
                                                            "title"=>__("Go to System"),
                                                            "var"=>array("pc"=>"%system_uuid",
                                                                         "view"=>"os",
                                                                        ),
                                                           ),
                                              ),
                                   "30"=>array("name"=>"mapped_username",
                                               "head"=>__("UserName"),
                                               "show"=>"y",
                                               "link"=>"n",
                                              ),
                                   "40"=>array("name"=>"mapped_device_id",
                                               "head"=>__("Drive ID"),
                                               "show"=>"y",
                                               "link"=>"n",
                                              ),
                                   "50"=>array("name"=>"mapped_provider_name",
                                               "head"=>__("UNC Path"),
                                               "show"=>"y",
                                               "link"=>"n",
                                              ),
                                   "60"=>array("name"=>"mapped_connect_as",
                                               "head"=>__("Connect As"),
                                               "show"=>"y",
                                               "link"=>"n",
                                              ),
 
                                  ),
                  );
?>